#pragma once

#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/tvm/create_tvm_client.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>
#include <crypta/styx/services/api/lib/config/clients/clients_config.pb.h>
#include <crypta/styx/services/api/lib/config/ping_config.pb.h>
#include <crypta/styx/services/api/lib/logic/common/mutation_sender/mutation_sender.h>
#include <crypta/styx/services/api/lib/logic/common/request_processor/request_processor.h>

#include <library/cpp/http/misc/parsed_request.h>

namespace NCrypta::NStyx::NApi {
    class TProcessorFactory {
    public:
        class TNotAllowedException : public yexception {
        };

        TProcessorFactory(
                NYtDynTables::TKvDatabase& replicaDatabase,
                TMutationSender& mutationSender,
                TDuration minDeleteInterval,
                const TStats::TSettings& statsSettings,
                const TPingConfig& pingConfig,
                const NTvmAuth::TTvmClient& tvmClient);

        IRequestProcessor* GetProcessor(const TStringBuf& method, const TStringBuf& service, const TClient& client);

    private:
        NYtDynTables::TKvDatabase& ReplicaDatabase;
        TMutationSender& MutationSender;
        TDuration MinDeleteInterval;
        const TStats::TSettings& StatsSettings;
        const TPingConfig& PingConfig;
        const NTvmAuth::TTvmClient& TvmClient;
    };
}
