#pragma once

#include "request_processor_factory.h"

#include <crypta/lib/native/http/request_reply.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>
#include <crypta/styx/services/api/lib/config/clients/clients_config.pb.h>
#include <crypta/styx/services/api/lib/config/ping_config.pb.h>
#include <crypta/styx/services/api/lib/logic/common/mutation_sender/mutation_sender.h>

namespace NCrypta::NStyx::NApi {
    class TWorker {
    public:
        TWorker(
                NYtDynTables::TKvDatabase& replicaDatabase,
                TMutationSender& mutationSender,
                TDuration minDeleteInterval,
                const TStats::TSettings& statsSettings,
                const TPingConfig& pingConfig,
                const TClientsConfig& clientsConfig,
                const NTvmAuth::TTvmClient& tvmClient);

        void ProcessRequest(NHttp::TRequestReply& reply);

    private:
        void ReplyError(NHttp::TRequestReply& reply, HttpCodes httpCode, const TString& message);

        const TClient& GetClientInfo(const TMaybe<NTvmAuth::TCheckedServiceTicket>& clientTvmId);

        TProcessorFactory RequestProcessorFactory;
        const TClientsConfig& ClientsConfig;
        TStats& Stats;
        NLog::TLogPtr Log;
    };
}
