#include "proto_comparators.h"

namespace NCrypta::NStyx {
    bool operator==(const TOblivionEvent& left, const TOblivionEvent& right) {
        return left.GetUnixtime() == right.GetUnixtime()
               && left.GetObfuscated() == right.GetObfuscated();
    }

    bool operator<(const TOblivionEvent& left, const TOblivionEvent& right) {
        return left.GetUnixtime() < right.GetUnixtime();
    }

    bool operator==(const TRepeatedOblivionEvents& left, const TRepeatedOblivionEvents& right) {
        return std::equal(left.begin(), left.end(), right.begin());
    }

    bool operator==(const TPuidState& left, const TPuidState& right) {
        return (left.GetPuid() == right.GetPuid())
            && (left.GetOblivionEvents() == right.GetOblivionEvents());
    }
}
