import os

import yt.wrapper as yt

from crypta.lib.python.yt import (
    tm_utils,
    yt_helpers,
)
from crypta.lib.python.yt.dyntable_utils import (
    dump,
    replica_utils,
)


def _create_dir(yt_client, dir):
    yt_client.mkdir(dir, recursive=True)


def _get_min_replication_timestamp(master_client, master_table, replica_cluster, replica_table):
    replica_id = replica_utils.get_replica_id_by_path(master_client, master_table, replica_cluster, replica_table)

    return min(
        tablet["current_replication_timestamp"]
        for tablet in master_client.get("#{}/@tablets".format(replica_id))
    )


def run(config, db_row_mapper, sort_by=None, postprocessor=None):
    master_client = yt_helpers.get_yt_client(config.MasterCluster)

    src_client = yt_helpers.get_yt_client(config.SrcCluster)
    src_cluster_name = yt_helpers.get_cluster_name(src_client)
    src_table = config.SrcTable
    src_tmp_dir = config.SrcTmpDir
    _create_dir(src_client, src_tmp_dir)

    dst_client = yt_helpers.get_yt_client(config.DstCluster)
    dst_tmp_dir = config.DstTmpDir
    dst_table = config.DstTable
    dst_dir = yt.ypath_dirname(dst_table)
    _create_dir(dst_client, dst_tmp_dir)
    _create_dir(dst_client, dst_dir)

    tm_client = tm_utils.get_client(os.environ.get("YT_TOKEN"))

    with src_client.TempTable(src_tmp_dir) as dump_path, src_client.TempTable(src_tmp_dir) as dict_path:
        min_replication_timestamp = _get_min_replication_timestamp(master_client, config.MasterTable, src_cluster_name, src_table)

        dump.dump_table(src_client, src_table, dump_path, config.SrcPool, timestamp=min_replication_timestamp)

        src_client.run_map(db_row_mapper, dump_path, dict_path)

        with dst_client.TempTable(dst_tmp_dir) as dump_transfer_target:
            force = True
            tm_utils.move_or_transfer_table(src_client, dict_path, dst_client, dump_transfer_target, force, tm_client)

            with dst_client.Transaction():
                dst_client.remove(dst_table, force=True)
                if sort_by is not None:
                    dst_client.run_sort(dump_transfer_target, dst_table, sort_by=sort_by)
                else:
                    dst_client.move(dump_transfer_target, dst_table)

                if postprocessor is not None:
                    postprocessor(dst_client, dst_table)
