#include "db_state.h"

#include <crypta/styx/services/common/data/proto_comparators.h>
#include <crypta/lib/native/id_obfuscator/id_hash/id_hash.h>

#include <algorithm>

using namespace NCrypta::NStyx;

TDbState::TDbState(TPuidStates&& puidStates, TDuration minDeleteInterval)
    : OriginalPuidStates(std::move(puidStates))
    , MinDeleteInterval(minDeleteInterval)
{
}

TDbState::TDbState(TDbState&& other)
    : OriginalPuidStates(std::move(other.OriginalPuidStates))
    , MinDeleteInterval(other.MinDeleteInterval)
{
}


bool TDbState::DeletePuid(ui64 puid, TInstant time) {
    TInstant lastDeleteTime;

    if (auto puidStateIt = OriginalPuidStates.find(puid); puidStateIt != OriginalPuidStates.end()) {
        const auto& oblivionEvents = puidStateIt->second.GetOblivionEvents();
        if (!oblivionEvents.empty()) {
            const auto lastOblivionEventIt = std::max_element(oblivionEvents.begin(), oblivionEvents.end());
            lastDeleteTime = TInstant::Seconds(lastOblivionEventIt->GetUnixtime());
        }
    }

    if ((time - lastDeleteTime) >= MinDeleteInterval) {
        if (time > NewDeleteTimes[puid]) {
            NewDeleteTimes[puid] = time;
            return true;
        }
    }
    return false;
}

TDbState::TPuidStates TDbState::GetPuidStates() const {
    TPuidStates result = OriginalPuidStates;

    for (const auto [puid, newDeleteTime]: NewDeleteTimes) {
        auto& puidState = result[puid];
        puidState.SetPuid(puid);

        const auto unixtime = newDeleteTime.Seconds();
        auto* newOblivionEvent = puidState.AddOblivionEvents();
        newOblivionEvent->SetUnixtime(unixtime);
        newOblivionEvent->SetObfuscated(NIdHashPrivate::ComputeHash(puid, unixtime));
    }

    return result;
}
