#pragma once

#include <crypta/styx/services/common/data/id.h>
#include <crypta/styx/services/common/data/proto/puid_state.pb.h>

#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/vector.h>
#include <util/system/types.h>

namespace NCrypta::NStyx {
    class TDbState {
    public:
        using TPuidStates = THashMap<ui64, TPuidState>;

        TDbState(TPuidStates&& puidStates, TDuration minDeleteInterval);
        TDbState(TDbState&& other);
        ~TDbState() = default;

        bool DeletePuid(ui64 puid, TInstant time);

        TPuidStates GetPuidStates() const;

    private:
        const TPuidStates OriginalPuidStates;
        const TDuration MinDeleteInterval;

        THashMap<ui64, TInstant> NewDeleteTimes;
    };
}
