#include "db_state_loader.h"

#include <crypta/styx/services/common/serializers/id_serializer.h>
#include <crypta/styx/services/common/serializers/puid_state_record_serializer.h>

#include <util/string/cast.h>

using namespace NCrypta::NStyx;

TDbStateLoader::TDbStateLoader(NLog::TLogPtr& log, TDuration minDeleteInterval)
    : Log(log)
    , MinDeleteInterval(minDeleteInterval)
{
}

TDbState TDbStateLoader::Load(TDatabase& database, const TVector<TId>& puids) {
    TVector<TString> serializedIds;
    serializedIds.reserve(puids.size());
    for (const auto& puid : puids) {
        Y_ENSURE("puid" == puid.Type, "Unexpected id type");
        serializedIds.push_back(NIdSerializer::ToString(puid));
    }

    auto records = database.Lookup(serializedIds);

    TDbState::TPuidStates puidStates;
    puidStates.reserve(records.size());
    for (const auto& record : records) {
        auto puid = NIdSerializer::FromString(record.Key);
        puidStates[FromString<ui64>(puid.Value)] = NPuidStateRecordSerializer::FromRecord(record);
    }
    return TDbState(std::move(puidStates), MinDeleteInterval);
}
