#pragma once

#include "db_state.h"

#include <crypta/styx/services/common/data/id.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>

#include <util/generic/hash_set.h>
#include <util/generic/vector.h>

namespace NCrypta::NStyx {
    class TDbStateLoader {
    public:
        using TDatabase = NYtDynTables::TKvDatabase;

        TDbStateLoader(NLog::TLogPtr& log, TDuration minDeleteInterval);

        TDbState Load(TDatabase& database, const TVector<TId>& puids);

    private:
        void EnqueueIds(const TVector<TId>& ids);
        void LoadOneStep(TDatabase& database, bool loadSecondOrderBackRefs, bool loadSecondOrderMatches);

        NLog::TLogPtr& Log;
        const TDuration MinDeleteInterval;

        THashSet<TString> RequestedIds;
        THashSet<TId> SeenIds;

        TVector<TString> LookupBatch;
    };
}
