#include "get_changes_batch.h"

#include <crypta/styx/services/common/serializers/puid_state_record_serializer.h>

#include <util/generic/algorithm.h>

NCrypta::NStyx::TChangesBatch NCrypta::NStyx::GetChangesBatch(const TDbState& dbState) {
    TChangesBatch result;

    const auto& puidStates = dbState.GetPuidStates();
    result.RecordsToUpdate.reserve(puidStates.size());

    for (const auto& [_, puidState] : puidStates) {
        result.RecordsToUpdate.emplace_back(NPuidStateRecordSerializer::ToRecord(puidState));
    }

    return result;
}
