#include "serializers.h"

#include <library/cpp/protobuf/json/json2proto.h>
#include <library/cpp/protobuf/json/proto2json.h>

using namespace NCrypta::NStyx;

TString NMutationSerializers::ToJson(const TMutationCommand& command) {
    return NProtobufJson::Proto2Json(command);
}

TMutationCommand NMutationSerializers::FromJson(const TStringBuf& jsonStr) {
    return NProtobufJson::Json2Proto<TMutationCommand>(jsonStr, {.AllowUnknownFields=false, .CastRobust=true});
}

