#include "id_serializer.h"

#include <util/generic/string.h>
#include <util/string/builder.h>
#include <util/string/split.h>

using namespace NCrypta::NStyx;

namespace {
    static const char DELIMITER = ':';

    TString JoinId(const TId& id) {
        return (TStringBuilder() << id.Type << DELIMITER << id.Value);
    }

    void SplitId(const TString& str, TString& type, TString& value) {
        Y_ENSURE(StringSplitter(str).Split(DELIMITER).Limit(2).TryCollectInto(&type, &value), "Could not split id '" << str << "' by delimiter '" << DELIMITER << "'");
    }
}


TString NIdSerializer::ToString(const TId& id) {
    return JoinId(id);
}

TId NIdSerializer::FromString(const TString& serialized) {
    TId id;
    SplitId(serialized, id.Type, id.Value);
    return id;
}

