#include "puid_state_record_serializer.h"

#include "id_serializer.h"
#include "puid_state_serializer.h"

#include <util/string/cast.h>

using namespace NCrypta;
using namespace NCrypta::NStyx;

TRecord NPuidStateRecordSerializer::ToRecord(const TPuidState& puidState) {
    TRecord result;
    result.Key = NIdSerializer::ToString(TId("puid", ToString(puidState.GetPuid())));

    TPuidState puidStateWoPuid = puidState;
    puidStateWoPuid.ClearPuid();
    result.Value = NPuidStateSerializer::ToString(puidStateWoPuid);

    return result;
}

TPuidState NPuidStateRecordSerializer::FromRecord(const TRecord& record) {
    TPuidState result;
    NPuidStateSerializer::FromString(record.Value, result);
    result.SetPuid(FromString<ui64>(NIdSerializer::FromString(record.Key).Value));
    return result;
}
