import copy

from crypta.lib.native.database.python.record import TRecord
from crypta.styx.services.common.data.proto.puid_state_pb2 import TPuidState


def FromRecord(record):
    result = TPuidState()
    result.ParseFromString(record.Value)
    result.Puid = int(record.Key.split(":", 1)[1])

    return result


def ToRecord(puid_state):
    state_copy = copy.deepcopy(puid_state)

    key = "puid:{}".format(state_copy.Puid)

    state_copy.ClearField("Puid")
    value = state_copy.SerializeToString()

    return TRecord.Create(key, value)
