#include "handler_factory.h"

#include <crypta/styx/services/common/mutation_commands/serializers.h>
#include <crypta/styx/services/common/mutation_commands/mutation_command.pb.h>
#include <crypta/styx/services/mutator/lib/handlers/delete_handler.h>


using namespace NCrypta::NStyx;
using namespace NCrypta::NStyx::NMutator;

THandlerFactory::THandlerFactory(TStats& stats)
    : Stats(stats)
{
}

THandlerPtr THandlerFactory::CreateHandler(const TStringBuf& commandStr) const {
    const auto& command = NMutationSerializers::FromJson(commandStr);
    const auto& commandType = command.GetCommandCase();

    if (commandType == TMutationCommand::kDelete) {
        return MakeHolder<TDeleteHandler>(command.GetDelete(), Stats);
    }

    return nullptr;
}
