#include "delete_handler.h"

#include <crypta/lib/native/time/shifted_clock.h>

#include <util/datetime/base.h>
#include <util/string/cast.h>

using namespace NCrypta::NStyx;
using namespace NCrypta::NStyx::NMutator;

TDeleteHandler::TDeleteHandler(const TDeleteCommand& deleteCommand, TStats& stats) 
    : THandler(TInstant::Seconds(deleteCommand.GetUnixtime()), stats)
    , DeleteCommand(deleteCommand)
{
}

TDeleteHandler::TDeleteHandler(TInstant commandTimestamp, TDeleteCommand deleteCommand, TStats& stats)
    : THandler(commandTimestamp, stats)
    , DeleteCommand(std::move(deleteCommand))
{
}

TString TDeleteHandler::GetShardingKey() const {
    return ToString(DeleteCommand.GetPuid());
}

TVector<TId> TDeleteHandler::GetLookupIds() {
    return {TId("puid", ToString(DeleteCommand.GetPuid()))};
}

void TDeleteHandler::UpdateDbState(TDbState& dbState) {
    IsDeleteApplied = dbState.DeletePuid(DeleteCommand.GetPuid(), TShiftedClock::Now());
}

void TDeleteHandler::OnCommitSuccess() {
    Stats.Count->Add("delete.commands.total");
    Stats.Count->Add(IsDeleteApplied ? "delete.commands.outcome.applied" : "delete.commands.outcom.skipped");
}
