#pragma once

#include "handler.h"

#include <crypta/styx/services/common/mutation_commands/mutation_command.pb.h>

#include <util/generic/hash.h>

namespace NCrypta::NStyx::NMutator {
    class TDeleteHandler : public THandler {
    public:
        TDeleteHandler(const TDeleteCommand& deleteCommand, TStats& stats);
        TDeleteHandler(TInstant commandTimestamp, TDeleteCommand deleteCommand, TStats& stats);

        TString GetShardingKey() const override;

        TVector<TId> GetLookupIds() override;
        void UpdateDbState(NStyx::TDbState& dbState) override;

    private:
        void OnCommitSuccess() override;

        const TDeleteCommand DeleteCommand;
        bool IsDeleteApplied = false;
    };
}
