#include "handler.h"

using namespace NCrypta::NStyx::NMutator;

THandler::THandler(TInstant commandTimestamp, TStats& stats)
    : Stats(stats)
    , CommandTimestamp(commandTimestamp)
    , CommitPromise(NYT::NewPromise<void>())
{
}

NYT::TFuture<void> THandler::GetCommitFuture() const {
    return CommitPromise.ToFuture();
}

void THandler::CommitSuccess() {
    Stats.Percentile->Add("commands.latency", (TInstant::Now() - CommandTimestamp).Seconds());

    OnCommitSuccess();

    CommitPromise.Set();
}
