#pragma once

#include <crypta/styx/services/common/data/id.h>
#include <crypta/styx/services/common/db_state/db_state.h>
#include <crypta/lib/native/stats/stats.h>

#include <yt/yt/core/actions/future.h>
#include <util/datetime/base.h>
#include <util/generic/ptr.h>

namespace NCrypta::NStyx::NMutator {
    class THandler {
    public:
        THandler(TInstant commandTimestamp, TStats& stats);
        virtual ~THandler() = default;

        NYT::TFuture<void> GetCommitFuture() const;

        virtual TString GetShardingKey() const = 0;

        virtual TVector<TId> GetLookupIds() = 0;
        virtual void UpdateDbState(TDbState& dbState) = 0;

        void CommitSuccess();

    protected:
        TStats& Stats;

    private:
        virtual void OnCommitSuccess() = 0;

        TInstant CommandTimestamp;
        NYT::TPromise<void> CommitPromise;
    };

    using THandlerPtr = THolder<THandler>;
}
