import argparse
import logging

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.styx.services.raw_events_publisher.lib import raw_events_publisher
from crypta.styx.services.raw_events_publisher.lib.config_pb2 import TConfig


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", required=True)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    config = yaml_config.parse_config(TConfig, args.config)
    logger.info(config)

    raw_events_publisher.run(config)
