import functools

from crypta.lib.native.database.python.record import TRecord
from crypta.lib.python import time_utils
from crypta.styx.services.common import db_dump
from crypta.styx.services.common.serializers.python import puid_state_record_serializer


def map_puid_state_to_events(row, unixtime):
    puid_state = puid_state_record_serializer.FromRecord(TRecord.Create(row["key"], row["value"]._bytes))

    for event in puid_state.OblivionEvents:
        yield {
            "id_type": "puid",
            "id": puid_state.Puid,
            "timestamp": event.Unixtime,
            "obfuscated": event.Obfuscated,
            "unixtime": unixtime,
        }


def run(config):
    db_dump.run(
        config=config,
        db_row_mapper=functools.partial(map_puid_state_to_events, unixtime=time_utils.get_current_time()),
        sort_by=["id_type", "id", "timestamp"],
    )
