from crypta.graph.matching.direct.proto.types_pb2 import TDirectEdge
from crypta.lib.python.yt import schema_utils
from crypta.tx.proto.transaction_pb2 import TTransaction


TRANSACTION_KEY_COLUMNS = ["CryptaId"]


def get_unordered_transaction_schema():
    return schema_utils.get_schema_from_proto(TTransaction)


def get_transaction_schema():
    return schema_utils.get_schema_from_proto(TTransaction, key_columns=TRANSACTION_KEY_COLUMNS)


def get_matching_schema():
    return schema_utils.get_schema_from_proto(TDirectEdge)


def get_stats_schema():
    return schema_utils.get_strict_schema([
        {"name": "CryptaIds", "type": "uint64", "required": "true"},
        {"name": "Date", "type": "string"},
        {"name": "Items", "type": "uint64", "required": "true"},
        {"name": "Source", "type": "string"},
        {"name": "TotalCostCents", "type": "uint64"},
        {"name": "TotalItemCostCents", "type": "uint64"},
        {"name": "TotalItemCount", "type": "double"},
        {"name": "TxIds", "type": "uint64", "required": "true"},
    ])
