import argparse
import logging

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.proto_secrets import proto_secrets
from crypta.tx.services.data_import.lib.common_task.config_pb2 import TConfig
from crypta.tx.services.data_import.tasks import ecom
import crypta.tx.services.data_import.tasks.eda.lib as eda
import crypta.tx.services.data_import.tasks.edadeal.lib as edadeal
import crypta.tx.services.data_import.tasks.kinopoisk.lib as kinopoisk
import crypta.tx.services.data_import.tasks.market.lib as market
import crypta.tx.services.data_import.tasks.lavka.lib as lavka
import crypta.tx.services.data_import.tasks.taxi.lib as taxi
import crypta.tx.services.data_import.tasks.trust.lib as trust
import crypta.tx.services.data_import.tasks.zapravki.lib as zapravki


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", required=True)

    subparsers = parser.add_subparsers()
    ecom.add_args_subparser(subparsers)
    eda.add_args_subparser(subparsers)
    edadeal.add_args_subparser(subparsers)
    lavka.add_args_subparser(subparsers)
    market.add_args_subparser(subparsers)
    taxi.add_args_subparser(subparsers)
    trust.add_args_subparser(subparsers)
    kinopoisk.add_args_subparser(subparsers)
    zapravki.add_args_subparser(subparsers)

    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    logger = logging.getLogger(__name__)

    args = parse_args()
    logger.info("Args: %s", args)

    config = yaml_config.parse_config(TConfig, args.config)
    logger.info("Config:\n%s", proto_secrets.get_copy_without_secrets(config))

    function = args.function

    kwargs = vars(args)
    del kwargs["config"]
    del kwargs["function"]

    function(config, logger, **kwargs)

    logger.info("Completed successfully")
