from crypta.tx.proto.transaction_source_pb2 import ETransactionSource
from crypta.tx.services.data_import.lib import common_task


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("eda", help="Import Eda data")
    parser.set_defaults(function=run)


def run(config, logger):
    common_task.run(
        config=config,
        transaction_source=ETransactionSource.EDA,
        yql_query="/query/eda_import.yql",
        yql_query_params={
            "eda_dm_order_dir": config.EdaDmOrderDir,
            "eda_order_dir": config.EdaOrderDir,
            "eda_order_revision_dir": config.EdaOrderRevisionDir,
            "eda_order_revision_item_dir": config.EdaOrderRevisionItemDir,
            "eda_place_table": config.EdaPlaceTable,
            "eda_place_menu_category_table": config.EdaPlaceMenuCategoryTable,
            "eda_place_menu_item_dir": config.EdaPlaceMenuItemDir,
            "eda_users_table": config.EdaUsersTable,
            "eda_matching_dir": config.EdaMatchingDir,
        },
        logger=logger,
    )
