from crypta.tx.proto.transaction_source_pb2 import ETransactionSource
from crypta.tx.services.data_import.lib import common_task


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("edadeal", help="Import Edadeal data")
    parser.set_defaults(function=run)


def run(config, logger):
    common_task.run(
        config=config,
        transaction_source=ETransactionSource.EDADEAL,
        yql_query="/query/edadeal_import.yql",
        yql_query_params={
            "edadeal_master_data_table": config.EdadealMasterDataTable,
            "edadeal_matching_table": config.EdadealMatchingTable,
            "edadeal_devices_light_table": config.EdadealDevicesLightTable,
            "edadeal_geo_table": config.EdadealGeoTable,
        },
        logger=logger,
    )
