from crypta.tx.proto.transaction_source_pb2 import ETransactionSource
from crypta.tx.services.data_import.lib import common_task


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("kinopoisk", help="Import Kinopoisk data")
    parser.set_defaults(function=run)


def run(config, logger):
    common_task.run(
        config=config,
        transaction_source=ETransactionSource.KINOPOISK,
        yql_query="/query/kinopoisk_import.yql",
        yql_query_params={
            "kinopoisk_purchases": config.KinopoiskOttPurchasesTable,
            "kinopoisk_profile": config.KinopoiskOttProfileTable,
        },
        logger=logger,
    )
