from crypta.tx.proto.transaction_source_pb2 import ETransactionSource
from crypta.tx.services.data_import.lib import common_task


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("lavka", help="Import Lavka data")
    parser.set_defaults(function=run)


def run(config, logger):
    common_task.run(
        config=config,
        transaction_source=ETransactionSource.LAVKA,
        yql_query="/query/lavka_import.yql",
        yql_query_params={
            "lavka_dm_order_dir": config.LavkaDmOrderDir,
            "lavka_dm_order_item_dir": config.LavkaDmOrderItemDir,
        },
        logger=logger,
    )
