from crypta.tx.proto.transaction_source_pb2 import ETransactionSource
from crypta.tx.services.data_import.lib import common_task


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("taxi", help="Import Yandex.Taxi data")
    parser.set_defaults(function=run)


def run(config, logger):
    common_task.run(
        config=config,
        transaction_source=ETransactionSource.TAXI,
        yql_query="/query/taxi_import.yql",
        yql_query_params={
            "taxi_order_dir": config.TaxiOrderDir,
        },
        logger=logger,
    )
