from crypta.tx.proto.transaction_source_pb2 import ETransactionSource
from crypta.tx.services.data_import.lib import common_task


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("trust", help="Import Trust data")
    parser.set_defaults(function=run)


def run(config, logger):
    common_task.run(
        config=config,
        transaction_source=ETransactionSource.TRUST,
        yql_query="/query/trust_import.yql",
        yql_query_params={
            "trust_v_payment_table": config.TrustVPaymentTable,
        },
        logger=logger,
    )
