from crypta.tx.proto.transaction_source_pb2 import ETransactionSource
from crypta.tx.services.data_import.lib import common_task


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("zapravki", help="Import Zapravki data")
    parser.set_defaults(function=run)


def run(config, logger):
    common_task.run(
        config=config,
        transaction_source=ETransactionSource.ZAPRAVKI,
        yql_query="/query/zapravki_import.yql",
        yql_query_params={
            "zapravki_table": config.ZapravkiTankerOrdersTable,
            "gas_station_dict_table": config.ZapravkiGasStationDictTable
        },
        logger=logger,
    )
