from collections import namedtuple
from datetime import timedelta as dt

from crypta.lib.python.spine.consts.yt_proxy import YtProxy
from crypta.lib.python.spine.juggler import juggler_check_generator
from crypta.lib.python.spine.sandbox import sandbox_scheduler
from sandbox.projects.crypta import tx_data_import


HOUR_1 = dt(hours=1)
HOURS_4 = dt(hours=4)
HOURS_12 = dt(hours=12)
HOURS_48 = dt(hours=48)


Task = namedtuple("Task", ["name", "crit_time", "kill_timeout", "schedule_daily_start_time", "retry_interval"])


def get_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(tags=["crypta-tx"], host="crypta-tx", yt_dependencies=YtProxy.Group.offline)

    sandbox = sandbox_scheduler.create_default_generator(juggler, ["TX"])

    for task in [
        Task(name="ecom", schedule_daily_start_time="2021-07-08T12:00:00+03:00", crit_time=HOURS_48, kill_timeout=HOURS_12, retry_interval=HOUR_1),
        Task(name="eda", schedule_daily_start_time="2020-12-25T14:00:00+03:00", crit_time=HOURS_48, kill_timeout=HOURS_12, retry_interval=HOUR_1),
        Task(name="edadeal", schedule_daily_start_time="2020-12-25T11:00:00+03:00", crit_time=HOURS_48, kill_timeout=HOURS_12, retry_interval=HOUR_1),
        Task(name="kinopoisk", schedule_daily_start_time="2022-01-20T13:00:00+03:00", crit_time=HOURS_48, kill_timeout=HOURS_12, retry_interval=HOUR_1),
        Task(name="lavka", schedule_daily_start_time="2020-12-25T14:00:00+03:00", crit_time=HOURS_48, kill_timeout=HOURS_12, retry_interval=HOUR_1),
        Task(name="market", schedule_daily_start_time="2020-12-25T12:00:00+03:00", crit_time=HOURS_48, kill_timeout=HOURS_12, retry_interval=HOUR_1),
        Task(name="taxi", schedule_daily_start_time="2021-01-29T20:00:00+03:00", crit_time=HOURS_48, kill_timeout=HOURS_12, retry_interval=HOUR_1),
        Task(name="trust", schedule_daily_start_time="2020-12-25T14:00:00+03:00", crit_time=HOURS_48, kill_timeout=HOURS_12, retry_interval=HOUR_1),
        Task(name="zapravki", schedule_daily_start_time="2022-01-20T11:00:00+03:00", crit_time=HOURS_48, kill_timeout=HOURS_12, retry_interval=HOUR_1),
    ]:
        task_cls = tx_data_import.CryptaTxDataImportTask
        sandbox.create_scheduler(
            task_cls=task_cls,
            extra_params={
                "task_name": task.name,
            },
            schedule_daily_start_time=task.schedule_daily_start_time,
            kill_timeout=task.kill_timeout,
            retry_interval=task.retry_interval
        ).check(
            crit_time=task.crit_time,
            juggler_service=task_cls.get_class_juggler_service(task.name),
        )

    sandbox.create_run_universal_bundle_scheduler(
        bundle_name="tx-ltp-logos-export",
        cmd=["{{cwd}}/crypta-tx-ltp-logos-export", "--config", "{{cwd}}/config.yaml"],
        secrets_env={
            "REACTOR_TOKEN": "sec-01ep4xy1ysb2kw1qkxm8nz3n33[token]",
        },
        schedule_daily_start_time="2021-07-05T00:00:00Z",
        kill_timeout=dt(hours=12),
        retry_interval=dt(hours=1),
        sequential_run=True,
    ).check(crit_time=dt(days=2))

    return juggler
