import argparse
import os
import subprocess


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--protoc", required=True, help="Path to protoc binary")
    parser.add_argument("--desc-path", required=True, help="Path to .desc file")
    parser.add_argument("--output-path", default=os.path.abspath("result.desc"), help="Output path for generated .desc file")
    parser.add_argument("--source-path", required=True, help="Path to .proto file")
    parser.add_argument("--proto-path", action="append", required=True, help="--proto-path arguments forwarded to protoc")
    return parser.parse_args()


def get_cmd(protoc, source_path, output_path, proto_paths):
    proto_paths_args = []
    for proto_path in proto_paths:
        proto_paths_args += ["--proto_path", proto_path]

    return [
        protoc,
        "--descriptor_set_out", output_path,
        "--include_imports",
        "--include_source_info"
    ] + proto_paths_args + [source_path]


def main():
    args = parse_args()

    cmd = get_cmd(args.protoc, args.source_path, args.output_path, args.proto_path)
    print "Compiling .desc file:\n", " ".join(cmd)
    subprocess.check_call(cmd)

    with open(args.output_path) as f:
        result = f.read()

    with open(args.desc_path) as f:
        reference = f.read()

    assert reference == result, "\n".join([
        ".desc and .proto files do not match",
        "Something changed in {} or its imports".format(args.source_path),
        "",
        "You can replace {} with {}, which was generated by this test".format(args.desc_path, args.output_path),
        "",
        "Approximate command to regenerate .desc file if the change is intentional (will affect parsing of some log in Logfeller):",
        "",
        " ".join(get_cmd(args.protoc, args.source_path, args.desc_path, args.proto_path))
    ])
