import os
import sys

from crypta.utils.conductor_manager.lib import (
    remove_tag,
    set_tag,
)


TASKS = {
    "set-tag" : set_tag,
    "remove-tag": remove_tag,
}


def main():
    if len(sys.argv) <= 1:
        print "Use {} {}".format(os.path.basename(sys.argv[0]), "".join(["[ ", " | ".join(TASKS), " ]"]))
        sys.exit(1)

    task = sys.argv[1]
    if task not in TASKS:
        print "Unknown task: {}".format(task)
        sys.exit(1)

    del sys.argv[1]
    TASKS[task].main()
