import argparse
import os
import sys


def get_oauth_token():
    token_file = os.path.expanduser("~/.conductor/token")
    token = os.getenv("CONDUCTOR_TOKEN")

    if token is None:
        if os.path.exists(token_file):
            with open(token_file) as f:
                token = f.read().strip()
        else:
            token = None

    if token is None:
        raise Exception("CONDUCTOR_TOKEN env not specified and file {} doesn't exists".format(token_file))

    return token


def finish(exit_code, logger):
    if exit_code:
        logger.error("Completed with errors.")
    else:
        logger.info("Completed successfully.")
    sys.exit(exit_code)


def normalize_group(group):
    return group.lstrip("%")


def parse_group_tag_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--tag', type=str, required=True, help="Conductor tag")
    parser.add_argument('--group', type=normalize_group, required=True, help="Conductor group")
    return parser.parse_args()
