import logging

from crypta.lib.python import conductor
from crypta.lib.python.logging import logging_helpers
from crypta.utils.conductor_manager.lib import common


logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = common.parse_group_tag_args()

    try:
        conductor.remove_tag(args.group, args.tag, common.get_oauth_token())
    except Exception:
        logger.exception("Can't remove tag")
        common.finish(1, logger)

    common.finish(0, logger)
