import logging
import os
import sys

from crypta.lib.python.logging import logging_helpers
from crypta.utils.dyn_tools.lib import (
    add_table_replica,
    disconnect_replica,
    list_replicas,
    remove_replica,
    setup,
)

TASKS = {
    "add-table-replica": add_table_replica,
    "disconnect-replica": disconnect_replica,
    "list-replicas": list_replicas,
    "remove-replica": remove_replica,
    "setup": setup,
}
VERBOSE_ARG = "--verbose"


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    if len(sys.argv) <= 1:
        print "Use {} [{}] {}".format(os.path.basename(sys.argv[0]), VERBOSE_ARG, "".join(["[", " | ".join(TASKS), "]"]))
        return 1

    task = sys.argv[1]
    if task in TASKS:
        del sys.argv[1]
        return TASKS[task].main()
    else:
        print "Unknown task: {}. Known tasks: {}".format(task, TASKS.keys())
        return 1
