import argparse

from crypta.lib.python import argparse_utils
from crypta.lib.python.yt import (
    tm_utils,
    yt_helpers,
)
from crypta.lib.python.yt.dyntable_utils import add_table_replica


def parse_args():
    parser = argparse.ArgumentParser(formatter_class=argparse.RawDescriptionHelpFormatter, description="Make and connect exact copy of an existing replica")
    parser.add_argument("--master-cluster", required=True, help="Master YT proxy")
    parser.add_argument("--master-table", required=True, help="Path to master table")
    parser.add_argument("--src-cluster", required=True, help="YT cluster of source replica")
    parser.add_argument("--src-table", required=True, help="Source replica table path")
    parser.add_argument("--dst-cluster", required=True, help="new replica cluster name")
    parser.add_argument("--dst-table", required=True, help="path to the new replica table")
    parser.add_argument("--temp-prefix", default="//tmp/", help="directory for temp files")
    parser.add_argument("--yt-pool", default="default", help="YT pool")
    parser.add_argument("--force", action="store_true", default=False, help="overwrite destination path")
    parser.add_argument("--enable-dynamic-store-read", default="false", type=argparse_utils.boolean_as_string)
    parser.add_argument("--enable-replicated-table-tracker", default="false", type=argparse_utils.boolean_as_string)

    return parser.parse_args()


def main():
    args = parse_args()

    add_table_replica.add_table_replica(
        master_client=yt_helpers.get_yt_client(args.master_cluster),
        master_table=args.master_table,
        src_client=yt_helpers.get_yt_client(args.src_cluster),
        src_table=args.src_table,
        dst_client=yt_helpers.get_yt_client(args.dst_cluster),
        dst_table=args.dst_table,
        temp_prefix=args.temp_prefix,
        yt_pool=args.yt_pool,
        force=args.force,
        tm_client=tm_utils.get_client(yt_token=None),
        replica_attrs={"enable_dynamic_store_read": args.enable_dynamic_store_read},
        replication_attrs={"enable_replicated_table_tracker": args.enable_replicated_table_tracker},
    )
