import argparse

from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.dyntable_utils import replica_utils


def get_args():
    parser = argparse.ArgumentParser(formatter_class=argparse.RawDescriptionHelpFormatter, description="Disconnect replica from master, leaving the table intact")
    parser.add_argument("--master-cluster", required=True, help="Master cluster")
    parser.add_argument("--master-table", required=True, help="Master table path")
    parser.add_argument("--replica-cluster", required=True, help="Replica cluster")
    parser.add_argument("--replica-table", required=True, help="Replica table path")

    return parser.parse_args()


def main():
    args = get_args()

    success = replica_utils.disconnect_replica(
        yt_helpers.get_yt_client(args.master_cluster),
        args.master_table,
        yt_helpers.get_yt_client(args.replica_cluster),
        args.replica_table
    )

    return 0 if success else 1
