import argparse

from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.dyntable_utils import replica_utils


def get_args():
    parser = argparse.ArgumentParser(formatter_class=argparse.RawDescriptionHelpFormatter, description="List replicas connected to master table")
    parser.add_argument("--master-cluster", required=True, help="YT Cluster, e.g. markov")
    parser.add_argument("--master-table", required=True, help="Path to master table")

    return parser.parse_args()


def main():
    args = get_args()

    replicas = replica_utils.list_replicas(yt_helpers.get_yt_client(args.master_cluster), args.master_table)
    replica_utils.print_replicas(replicas)
