import argparse

from crypta.lib.python import argparse_utils
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.dyntables import (
    kv_schema,
    kv_setup,
)


def get_args():
    parser = argparse.ArgumentParser(description="Setup master table with replicas from scratch", formatter_class=argparse.RawDescriptionHelpFormatter)

    parser.add_argument("--bundle", default="default", help="")
    parser.add_argument("--tablet-count", type=int, required=True, default=50, help="")
    parser.add_argument("--sync", type=argparse_utils.boolean_as_string, default="true", help="Use sync replica")
    parser.add_argument("--enable-tablet-balancer", type=argparse_utils.boolean_as_string, default="true", help="Enable tablet balancer")
    parser.add_argument("--enable-replicated-table-tracker", type=argparse_utils.boolean_as_string, default="true",
                        help="Track health of sync replica(s) and switch the sync role to a healthy async replica is case of failure")
    parser.add_argument("--sync-replica-count", type=int, default=1, help="Exact number of sync replicas to maintain")

    parser.add_argument("--master-cluster", required=True, help="Master cluster, e.g., markov")
    parser.add_argument("--master-table", required=True, help="Master table path")

    parser.add_argument("--replica-clusters", nargs="+", help="Replica clusters, e.g. seneca-sas seneca-vla seneca-man", metavar="replica-cluster")
    parser.add_argument("--replica-table", required=True, help="Path to replica table (used on every replica-cluster")

    return parser.parse_args()


def main():
    args = get_args()

    master_yt_client = yt_helpers.get_yt_client(args.master_cluster)
    replica_clusters = [(cluster_name, yt_helpers.get_yt_client(cluster_name)) for cluster_name in args.replica_clusters]

    kv_setup.kv_setup(
        master_yt_client,
        replica_clusters,
        args.master_table,
        args.replica_table,
        kv_schema.get(),
        bundle=args.bundle,
        pivot_keys=kv_schema.create_pivot_keys(args.tablet_count),
        sync=args.sync,
        enable_tablet_balancer=args.enable_tablet_balancer,
        sync_replica_count=args.sync_replica_count,
        enable_replicated_table_tracker=args.enable_replicated_table_tracker,
    )
