import argparse
import logging
import os
import subprocess
import sys

from crypta.lib.python.logging import logging_helpers


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser(description="Run BIN1 --config CONFIG; BIN2 --config CONFIG; ...")
    parser.add_argument("--config", help="Path to config", required=True)
    parser.add_argument("--bin", action="append", help="Binary to run", required=True)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    args = parse_args()
    logger.info(args)

    for binary in args.bin:
        cmd = [binary, "--config", args.config]
        logger.info("Run %s", cmd)
        subprocess.check_call(cmd, stdout=sys.stdout, stderr=sys.stderr, shell=False, env=os.environ)

    logger.info("Done!")
