#include <util/string/split.h>
#include <util/datetime/base.h>
#include <library/cpp/protobuf/json/json2proto.h>
#include <library/cpp/protobuf/json/proto2json.h>
#include <library/cpp/logger/global/global.h>
#include <crypta/graph/soup/config/proto/bigb.pb.h>
#include <crypta/graph/soup/config/cpp/soup_config.h>
#include "links.h"

TString CreateLinksPayload(const TInjectorOptions& config) {
    using namespace NCrypta::NSoup;
    using namespace NCrypta::NIdentifiersProto;

    NBB::TLinks result;
    int value;

    /* defaults to empty message */
    NProtobufJson::Json2Proto(config.GetJson(), result);

    for (const auto& link : config.GetLink()) {
        TVector<TString> splitted;
        Split(link, ":", splitted);

        Y_ASSERT(splitted.size() == 2);

        auto vertex = result.AddVertices();
        vertex->SetId(splitted[1]);
        if (TryFromString(splitted[0], value)) {
            vertex->SetIdType(IdType(static_cast<NIdType::EIdType>(value)).GetType());
        } else {
            vertex->SetIdType(IdType(splitted[0]).GetType());
        }
    }

    if (TryFromString(config.GetSourceType(), value)) {
        result.SetSourceType(SourceType(static_cast<NSourceType::ESourceType>(value)).GetType());
    } else {
        result.SetSourceType(SourceType(config.GetSourceType()).GetType());
    }

    if (TryFromString(config.GetLogSource(), value)) {
        result.SetLogSource(LogSourceType(static_cast<NLogSource::ELogSourceType>(value)).GetType());
    } else {
        result.SetLogSource(LogSourceType(static_cast<NLogSource::ELogSourceType>(value)).GetType());
    }

    result.AddUsage(static_cast<NBB::EBbLinkUsage>(config.GetUsage()));
    result.SetIndevice(config.GetIndevice());

    if (config.GetTimestamp() == 0) {
        result.SetLogEventTimestamp(TInstant::Now().Seconds());
    } else {
        result.SetLogEventTimestamp(config.GetTimestamp());
    }

    INFO_LOG << "Sending: " << NProtobufJson::Proto2Json(result) << Endl;

    TString result_str;
    Y_PROTOBUF_SUPPRESS_NODISCARD result.SerializeToString(&result_str);
    return result_str;
}
