#include <util/system/env.h>
#include <kikimr/persqueue/sdk/deprecated/cpp/v2/logger.h>

#include <crypta/utils/injector/options.pb.h>
#include <crypta/lib/native/cmd_args/parse_pb_options.h>
#include <library/cpp/logger/log.h>
#include <library/cpp/logger/global/global.h>
#include <memory>
#include "tvm.h"
#include "writer.h"
#include "links.h"

int main(int argc, const char** argv) {
    try {
        auto config = NCrypta::ParsePbOptionsExtended<TInjectorOptions>(argc, argv);

        DoInitGlobalLog(
            CreateLogBackend(config.GetLogOptions().GetType(),
                             static_cast<ELogPriority>(config.GetLogOptions().GetMainPriority()),
                             true));

        INFO_LOG << "Writing to: " << config.GetLogbrokerOptions().GetServer() << "/"
                 << config.GetLogbrokerOptions().GetTopic() << " by "
                 << config.GetTvmOptions().GetClientAlias() << "." << Endl;

        if (!config.LinkSize() && config.GetJson() == "{}") {
            ERROR_LOG << "Need to provide json or at least one link parameter." << Endl;
            return 1;
        }

        TLogbrokerWriter writer(config);
        auto payload = CreateLinksPayload(config);
        if (writer.Write(payload) == TLogbrokerWriter::EResult::OK) {
            INFO_LOG << "Written succesfully." << Endl;
        } else {
            INFO_LOG << "Error writing message." << Endl;
        }
    } catch (const yexception& e) {
        ERROR_LOG << e.what() << Endl;
        return 1;
    }

    return 0;
}
