#pragma once

#include <crypta/utils/injector/options.pb.h>
#include <library/cpp/tvmauth/client/facade.h>
#include <util/string/cast.h>

#include <memory>

class TTvmKeyManager {
private:
    TInjectorOptions::TTvmOptions Options;
    std::shared_ptr<NTvmAuth::TTvmClient> TvmClient;

public:
    TTvmKeyManager(TInjectorOptions::TTvmOptions options, TVector<TString> serviceIds)
        : Options(options)
    {
        NTvmAuth::NTvmApi::TClientSettings settings;
        NTvmAuth::NTvmApi::TClientSettings::TDstMap dstMap;

        settings.SetSelfTvmId(FromString<ui32>(Options.GetClientTvmId()));
        settings.EnableServiceTicketChecking();
        settings.EnableUserTicketChecking(NTvmAuth::EBlackboxEnv::ProdYateam);

        for (const auto& serviceId : serviceIds) {
            dstMap[serviceId] = FromString<ui32>(serviceId);
        }

        settings.EnableServiceTicketsFetchOptions(Options.GetClientTvmSecret(), std::move(dstMap));
        NTvmAuth::TLoggerPtr logger = MakeIntrusive<NTvmAuth::TCerrLogger>(Options.GetTvmLogPriority());
        TvmClient = std::make_shared<NTvmAuth::TTvmClient>(settings, logger);
    }

    TString GetTicketFor(const TString serviceId) const {
        return TvmClient->GetServiceTicketFor(serviceId);
    }

    TString GetTicketFor(const ui32 serviceId) const {
        return TvmClient->GetServiceTicketFor(ToString(serviceId));
    }

    std::shared_ptr<NTvmAuth::TTvmClient> GetTvmClient() const {
        return TvmClient;
    }

    TString GetClientAlias() const {
        return Options.GetClientAlias();
    }

    TInjectorOptions::TTvmOptions& GetOptions() {
        return Options;
    }
};
