#include "writer.h"
#include <thread>
#include <iostream>
#include <util/string/cast.h>
#include <util/string/builder.h>

using namespace NPersQueue;

std::shared_ptr<ICredentialsProvider> TLogbrokerWriter::CreateCredentialsProvider() {
    return CreateTVMCredentialsProvider(
        Options.GetTvmOptions().GetClientTvmSecret(),
        FromString<ui32>(Options.GetTvmOptions().GetClientTvmId()),
        FromString<ui32>(Options.GetLogbrokerOptions().GetServerTvmId()),
        Logger);
}

THolder<IProducer> TLogbrokerWriter::CreateProducer(ui32 pg) {
    TProducerSettings settings;

    auto alias = Options.GetTvmOptions().GetClientAlias();

    settings.Server.Address = Options.GetLogbrokerOptions().GetServer();
    settings.Topic = Options.GetLogbrokerOptions().GetTopic();
    settings.SourceId = ToString(TInstant::Now().MilliSeconds()) + "-" + ToString(pg);

    settings.PartitionGroup = pg;
    settings.ReconnectOnFailure = true;
    settings.Codec = NPersQueueCommon::ECodec::GZIP;

    settings.CredentialsProvider = CredentialsProvider;

    auto producer = PQ.CreateProducer(settings, Logger);
    auto future = producer->Start();
    future.Wait();

    if (future.GetValue().Response.HasError()) {
        return THolder<IProducer>(nullptr);
    } else {
        return producer;
    }
}

TLogbrokerWriter::EResult TLogbrokerWriter::Write(const TString& message) {
    TInstant timestamp = TInstant::Now();
    auto future = Producer->Write(Sequence++, TData{message, timestamp});
    future.Wait();

    if (future.GetValue().Response.HasError()) {
        return EResult::NEOK;
    }

    return EResult::OK;
}
