#pragma once

#include <crypta/utils/injector/options.pb.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/stream/output.h>
#include <util/datetime/base.h>
#include <util/generic/vector.h>
#include <util/system/mutex.h>
#include <kikimr/persqueue/sdk/deprecated/cpp/v2/persqueue.h>
#include <util/string/cast.h>

#include <future>

using namespace NPersQueue;

class TLogbrokerWriter {
public:
    enum class EResult {
        OK,
        NEOK
    };

private:
    const TInjectorOptions Options;
    TIntrusivePtr<ILogger> Logger;
    std::shared_ptr<ICredentialsProvider> CredentialsProvider;
    TPQLib PQ;
    THolder<IProducer> Producer;
    int Sequence;

    THolder<IProducer> CreateProducer(ui32);
    std::shared_ptr<ICredentialsProvider> CreateCredentialsProvider();

public:
    TLogbrokerWriter(const TInjectorOptions& options)
        : Options(options)
        , Logger(MakeIntrusive<NPersQueue::TCerrLogger>(static_cast<int>(options.GetLogbrokerOptions().GetLogPriority())))
        , CredentialsProvider(CreateCredentialsProvider())
        , PQ({.ThreadsCount = options.GetLogbrokerOptions().GetThreadsCount(), .DefaultLogger = Logger})
        , Producer(CreateProducer(options.GetLogbrokerOptions().GetPartitionGroup()))
        , Sequence(0)
    {
    }
    EResult Write(const TString& message);
};
