import datetime
import logging

import yt.wrapper as yt

import crypta.lib.python.bt.conf.conf as conf
from crypta.lib.python.getoptpb import ParsePbOptions
from crypta.utils.merge_to_bigb_collector.lib import config_pb2
from crypta.lib.python import time_utils
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.yt import yt_helpers

logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    conf.use_proto(ParsePbOptions(config_pb2.TConfig))

    logger.info(conf.proto)

    client = yt_helpers.get_yt_client(conf.proto.Yt.Proxy, yt_pool=conf.proto.Yt.Pool)
    client.create("map_node", conf.proto.OutputDir, recursive=True, ignore_existing=True)

    with client.Transaction():
        src_tables = list(client.list(conf.proto.FreshDir, absolute=True))
        if not src_tables:
            logger.info("Nothing to merge, exiting")
            return

        dst = yt.ypath_join(conf.proto.OutputDir, datetime.datetime.fromtimestamp(time_utils.get_current_time()).isoformat())

        client.run_merge(src_tables, dst, spec={"combine_chunks": True})
        yt_helpers.set_ttl(dst, datetime.timedelta(days=conf.proto.TtlDays), client, remove_if_empty=True)

        for table in src_tables:
            client.remove(table)
