import argparse
import difflib
import os
import sys

from library.python import find_root

from crypta.utils.package_build_deps.lib import (
    package,
    testenv_task,
    testenv_task_filter
)

DEFAULT_PREFIXES = ['/trunk/arcadia/crypta/']


def init_args():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--package', required=True, help='Package JSON file')
    parser.add_argument('--testenv-task', default='', help='TestEnv task YAML file')
    parser.add_argument('--testenv-task-type', help='TestEnv task type')
    parser.add_argument('--commit-path-prefixes', action="append", help='Commit path prefixes, comma-separated')
    return parser.parse_args()


def main():
    sys.exit(0)
    # TODO: rework to use with Arcadia CI (CRYPTA-16931)
    args = init_args()

    package_path = os.path.realpath(args.package)
    arcadia_root = find_root.detect_root(package_path)

    with open(package_path, 'r') as f:
        pkg = package.parse_package(f.read())

    arcadia_root_relative_package_path = package_path[len(arcadia_root) + 1:]

    package_filter = testenv_task_filter.make_filter(pkg, arcadia_root_relative_package_path, args.commit_path_prefixes or DEFAULT_PREFIXES)

    if not args.testenv_task:
        print testenv_task.serialize_task(package_filter)
        sys.exit(1)  # protection against misuse in test

    with open(args.testenv_task, 'r') as f:
        task = testenv_task.parse_task(f.read(), args.testenv_task_type)

    task_filter = testenv_task.get_filter(task)

    if package_filter != task_filter:
        sys.stderr.write('TestEnv task filter doesn\'t match package dependencies:\n{diff}'.format(diff=testenv_task_filter.diff_filters(package_filter, task_filter)))
        sys.exit(1)

    if testenv_task.is_ya_package(task):
        task_package = testenv_task.get_package(task)

        if arcadia_root_relative_package_path != task_package:
            sys.stderr.write('TestEnv packages don\'t match package path:\n{diff}'.format(
                diff='\n'.join(difflib.ndiff([arcadia_root_relative_package_path], [task_package]))
            ))
            sys.exit(1)

    sys.exit(0)


if __name__ == '__main__':
    main()
