import json
import os


def parse_package(package_str):
    def encode(data, ignore_dicts=False):  # https://stackoverflow.com/questions/956867/how-to-get-string-objects-instead-of-unicode-from-json
        if isinstance(data, unicode):
            return data.encode('utf-8')

        if isinstance(data, list):
            return [encode(item, ignore_dicts=True) for item in data]

        if isinstance(data, dict) and not ignore_dicts:
            return {
                encode(key, ignore_dicts=True): encode(value, ignore_dicts=True)
                for key, value in data.iteritems()
            }

        return data

    return json.loads(package_str, object_hook=encode)


def get_targets(package):
    return package.get('build', {}).get('targets', [])


def get_data_paths(package, data_type):
    return map(lambda d: d['source']['path'], filter(lambda d: d.get('source', {}).get('type') == data_type, package.get('data', [])))


def get_arcadia_paths(package):
    return get_data_paths(package, 'ARCADIA')


def get_relative_paths(package):
    return get_data_paths(package, 'RELATIVE')


def get_debian_dir_path(package_path):
    package_dir, _ = os.path.split(package_path)
    debian_dir_path = os.path.join(package_dir, "debian")

    if os.path.isdir(debian_dir_path):
        return debian_dir_path

    return None
