import argparse
import json

import yaml

from crypta.lib.python import templater


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--template", required=True, help="Path to template file")
    parser.add_argument("--output", required=True, help="Path to rendered output file")
    parser.add_argument("--context", required=True, help="JSON with Jinja variables", type=json.loads)

    return parser.parse_args()


def main():
    args = parse_args()
    templater.render_file(args.template, args.output, args.context, strict=True)

    with open(args.output) as f:
        yaml.safe_load(f)
