import argparse

from crypta.lib.native.rtmr.benchmark_utils.proto import job_input_pb2
from crypta.lib.python import yaml_config
from crypta.lib.python.rtmr import api


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--hostname", default="rtmr-man4.search.yandex.net", help="RTMR host")
    parser.add_argument("--record-count", default=100, help="Number of records", type=int)
    parser.add_argument("--config", required=True, help="Generator config", type=yaml_config.load)
    parser.add_argument("--output", required=True, help="Path to output")
    return parser.parse_args()


def preview_to_proto(records, table_indexes):
    job_input = job_input_pb2.TJobInput()
    max_timestamp = 0

    for record in records:
        item = job_input.Items.add()
        item.InputState = bytes(record["prev_state"])
        for row in record["input"]:
            proto_row = item.InputRows.add()
            proto_row.Key = row["key"]
            proto_row.SubKey = row["subkey"]
            proto_row.Index = table_indexes[row["table"]]
            proto_row.Value = bytes(row["value"])
            max_timestamp = max(max_timestamp, int(row["subkey"]))

    job_input.Timestamp = max_timestamp
    return job_input


def main():
    args = parse_args()

    client = api.Client(args.hostname, {})

    records = client.preview_operation(args.config["operation"], args.record_count)

    with open(args.output, "wb") as f:
        f.write(preview_to_proto(records, args.config["table_index"]).SerializeToString())
